<?php
// wallet/success.php

require_once '../includes/config.php';

if (!isLoggedIn()) {
    redirect('../login.php');
}

$transaction_id = isset($_GET['transaction_id']) ? intval($_GET['transaction_id']) : 0;
$status = isset($_GET['status']) ? sanitizeInput($_GET['status']) : 'completed';

// Get transaction details
$stmt = $pdo->prepare("
    SELECT wt.*, w.user_id 
    FROM wallet_transactions wt
    JOIN wallet w ON wt.wallet_id = w.id
    WHERE wt.id = ? AND w.user_id = ?
");
$stmt->execute([$transaction_id, $_SESSION['user_id']]);
$transaction = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$transaction) {
    redirect('index.php');
}

$user = getUserById($_SESSION['user_id']);
$wallet_balance = getWalletBalance($_SESSION['user_id']);

$pageTitle = ($status === 'pending') ? "Request Submitted - " . SITE_NAME : "Payment Success - " . SITE_NAME;
require_once '../includes/header.php';
?>

<style>
    .payment-result {
        max-width: 600px;
        margin: 0 auto;
        text-align: center;
    }
    
    .result-icon {
        font-size: 4rem;
        margin-bottom: 1rem;
    }
    
    .success-icon {
        color: #2e7d32;
    }
    
    .pending-icon {
        color: #ff8f00;
    }
    
    .transaction-details {
        background: white;
        border-radius: 8px;
        padding: 2rem;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        margin-top: 2rem;
    }
    
    .detail-item {
        display: flex;
        justify-content: space-between;
        padding: 0.75rem 0;
        border-bottom: 1px solid #eee;
    }
    
    .detail-item:last-child {
        border-bottom: none;
    }
    
    .detail-label {
        font-weight: 500;
    }
    
    .detail-value {
        font-weight: 600;
    }
    
    .back-btn {
        margin-top: 2rem;
        width: 100%;
    }
    
    .status-badge {
        display: inline-block;
        padding: 0.25rem 0.75rem;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 600;
    }
    
    .status-pending {
        background-color: #fff3e0;
        color: #ff8f00;
    }
    
    .status-completed {
        background-color: #e8f5e9;
        color: #2e7d32;
    }
</style>

<div class="dashboard-container">
    <div class="sidebar">
        <!-- Sidebar content same as before -->
    </div>
    
    <div class="main-content">
        <div class="payment-result">
            <?php if ($status === 'pending'): ?>
                <div class="result-icon pending-icon">
                    <i class="fas fa-clock"></i>
                </div>
                <h2>Request Submitted Successfully!</h2>
                <p>Your deposit request is pending admin approval.</p>
            <?php else: ?>
                <div class="result-icon success-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                <h1>Wallet Load Request Submitted Successfully!</h1>
                <p>Thank you for adding funds to your wallet.</p>
                <p>Your deposit request awaiting for admin approval.</p>
            <?php endif; ?>
            
            <div class="transaction-details">
                <h3>Transaction Details</h3>
                
                <div class="detail-item">
                    <span class="detail-label">Status:</span>
                    <span class="status-badge status-<?= $transaction['status'] ?>">
                        <?= ucfirst($transaction['status']) ?>
                    </span>
                </div>
                <div class="detail-item">
                    <span class="detail-label">Amount:</span>
                    <span class="detail-value">Nrs. <?= number_format($transaction['amount'], 2) ?></span>
                </div>
                <div class="detail-item">
                    <span class="detail-label">Type:</span>
                    <span class="detail-value"><?= ucfirst($transaction['transaction_type']) ?></span>
                </div>
                <div class="detail-item">
                    <span class="detail-label">Date:</span>
                    <span class="detail-value"><?= date('M d, Y H:i', strtotime($transaction['created_at'])) ?></span>
                </div>
                <div class="detail-item">
                    <span class="detail-label">Reference:</span>
                    <span class="detail-value"><?= htmlspecialchars($transaction['reference']) ?></span>
                </div>
                
                <?php if ($status === 'completed'): ?>
                <div class="detail-item">
                    <span class="detail-label">Total Wallet Balance:</span>
                    <span class="detail-value">Nrs. <?= number_format($wallet_balance, 2) ?></span>
                </div>
                <?php endif; ?>
            </div>
            
            <?php if ($status === 'pending'): ?>
            <div class="note">
                <p class="text-muted">You will receive a notification once your deposit is approved.</p>
            </div>
            <?php endif; ?>
            
            <a href="index.php" class="btn btn-primary back-btn">
                <i class="fas fa-arrow-left"></i> Back to Wallet
            </a>
        </div>
    </div>
</div>

<?php require_once 'footer.php'; ?>