<?php
// wallet/pending_approval.php

require_once '../includes/config.php';

if (!isLoggedIn()) {
    redirect('../login.php');
}

$transaction_id = isset($_GET['transaction_id']) ? intval($_GET['transaction_id']) : 0;

// Verify transaction belongs to user
$stmt = $pdo->prepare("
    SELECT wt.* 
    FROM wallet_transactions wt
    JOIN wallet w ON wt.wallet_id = w.id
    WHERE wt.id = ? AND w.user_id = ? AND wt.status = 'pending'
");
$stmt->execute([$transaction_id, $_SESSION['user_id']]);
$transaction = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$transaction) {
    redirect('index.php');
}

$pageTitle = "Pending Approval - " . SITE_NAME;
require_once '../includes/header.php';
?>

<style>
    .pending-approval {
        max-width: 600px;
        margin: 0 auto;
        text-align: center;
    }
    
    .pending-icon {
        color: #ff8f00;
        font-size: 4rem;
    }
    
    .transaction-info {
        background: white;
        border-radius: 8px;
        padding: 2rem;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        margin-top: 2rem;
    }
    
    .back-btn {
        margin-top: 2rem;
        width: 100%;
    }
</style>

<div class="dashboard-container">
    <div class="sidebar">
        <div class="user-profile">
            <div class="avatar">
                <i class="fas fa-user-circle"></i>
            </div>
            <h3><?= htmlspecialchars($_SESSION['username'], ENT_QUOTES, 'UTF-8') ?></h3>
            <p><?= htmlspecialchars($_SESSION['email'], ENT_QUOTES, 'UTF-8') ?></p>
        </div>
        
        <ul class="nav-links">
            <!-- Same navigation as other wallet pages -->
        </ul>
    </div>
    
    <div class="main-content">
        <div class="pending-approval">
            <div class="pending-icon">
                <i class="fas fa-clock"></i>
            </div>
            <h2>Payment Pending Approval</h2>
            <p>Your deposit request is being reviewed by our team.</p>
            
            <div class="transaction-info">
                <p><strong>Amount:</strong> Nrs. <?= number_format($transaction['amount'], 2) ?></p>
                <p><strong>Reference:</strong> <?= htmlspecialchars($transaction['reference']) ?></p>
                <p><strong>Date:</strong> <?= date('M d, Y H:i', strtotime($transaction['created_at'])) ?></p>
                
                <p class="text-muted">You will receive a notification once your deposit is approved.</p>
            </div>
            
            <a href="index.php" class="btn btn-primary back-btn">
                <i class="fas fa-arrow-left"></i> Back to Wallet
            </a>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>