<?php
require_once 'includes/config.php';

try {
    // Check if user_id column already exists
    $columnCheck = $pdo->query("SHOW COLUMNS FROM wallet_transactions LIKE 'user_id'");
    
    if ($columnCheck->rowCount() === 0) {
        // Step 1: Add user_id column
        $pdo->exec("ALTER TABLE wallet_transactions ADD COLUMN user_id INT NOT NULL AFTER id");
        echo "Added user_id column<br>";
    } else {
        echo "user_id column already exists<br>";
    }

    // Step 2: Verify and populate user_id from wallet table
    $pdo->exec("UPDATE wallet_transactions wt
               JOIN wallet w ON wt.wallet_id = w.id
               SET wt.user_id = w.user_id
               WHERE wt.user_id = 0 OR wt.user_id IS NULL");
    echo "Populated user_id values<br>";

    // Step 3: Add foreign key constraint if it doesn't exist
    $fkCheck = $pdo->query("
        SELECT CONSTRAINT_NAME 
        FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS
        WHERE TABLE_NAME = 'wallet_transactions'
        AND CONSTRAINT_TYPE = 'FOREIGN KEY'
        AND CONSTRAINT_NAME = 'fk_user_transaction'
    ");
    
    if ($fkCheck->rowCount() === 0) {
        $pdo->exec("ALTER TABLE wallet_transactions ADD CONSTRAINT fk_user_transaction
                   FOREIGN KEY (user_id) REFERENCES users(id)");
        echo "Added foreign key constraint<br>";
    } else {
        echo "Foreign key already exists<br>";
    }

    echo "Migration completed successfully! Please delete this file.";
} catch (PDOException $e) {
    echo "<br>Migration failed at step: " . $e->getMessage();
    error_log("Migration Error: " . $e->getMessage());
}