<?php
// install.php

require_once 'includes/config.php';

try {
    // Insert sample subscriptions
    $subscriptions = [
        ['name' => 'Basic', 'description' => 'Access to standard channels', 'price' => 9.99, 'duration_days' => 30],
        ['name' => 'Premium', 'description' => 'Access to all channels including sports and movies', 'price' => 19.99, 'duration_days' => 30],
        ['name' => 'Annual', 'description' => 'Full access for 1 year (best value)', 'price' => 199.99, 'duration_days' => 365]
    ];
    
    foreach ($subscriptions as $sub) {
        $stmt = $pdo->prepare("
            INSERT INTO subscriptions (name, description, price, duration_days) 
            VALUES (?, ?, ?, ?)
        ");
        $stmt->execute([$sub['name'], $sub['description'], $sub['price'], $sub['duration_days']]);
    }
    
    // Create admin user
    $hashed_password = password_hash('admin123', PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("
        INSERT INTO users (username, email, password) 
        VALUES (?, ?, ?)
    ");
    $stmt->execute(['admin', 'admin@example.com', $hashed_password]);
    
    $user_id = $pdo->lastInsertId();
    
    // Add funds to admin wallet
    $stmt = $pdo->prepare("INSERT INTO wallet (user_id, balance) VALUES (?, ?)");
    $stmt->execute([$user_id, 1000.00]);
    
    echo "Sample data inserted successfully!";
} catch (PDOException $e) {
    die("Error inserting sample data: " . $e->getMessage());
}
?>