<?php
// index.php

require_once 'includes/config.php';

if (isLoggedIn()) {
    redirect('dashboard.php');
}

$pageTitle = "Home - " . SITE_NAME;
require_once 'includes/header.php';
?>

<div class="hero-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h1 class="display-4 fw-bold mb-4">Premium IPTV Service</h1>
                <p class="lead mb-4">Stream thousands of channels in HD quality with our reliable IPTV service. Enjoy your favorite shows, movies, and sports anytime, anywhere.</p>
                <div class="d-flex gap-3">
                    <a href="register.php" class="btn btn-primary btn-lg px-4">Sign Up Now</a>
                    <a href="login.php" class="btn btn-outline-light btn-lg px-4">Login</a>
                </div>
            </div>
            <div class="col-lg-6">
                <img src="assets/img/hero-image.png" alt="IPTV Streaming" class="img-fluid rounded shadow">
            </div>
        </div>
    </div>
</div>

<section class="py-5">
    <div class="container">
        <h2 class="text-center mb-5">Why Choose Our IPTV Service?</h2>
        <div class="row g-4">
            <div class="col-md-4">
                <div class="feature-card p-4 rounded shadow-sm">
                    <div class="feature-icon mb-3">
                        <i class="bi bi-tv fs-1 text-primary"></i>
                    </div>
                    <h3>10,000+ Channels</h3>
                    <p>Access to international channels from around the world including sports, movies, news and more.</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="feature-card p-4 rounded shadow-sm">
                    <div class="feature-icon mb-3">
                        <i class="bi bi-speedometer2 fs-1 text-primary"></i>
                    </div>
                    <h3>High Quality Streams</h3>
                    <p>Enjoy buffer-free streaming in Full HD, 4K and 8K quality with our optimized servers.</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="feature-card p-4 rounded shadow-sm">
                    <div class="feature-icon mb-3">
                        <i class="bi bi-devices fs-1 text-primary"></i>
                    </div>
                    <h3>Multi-Device Support</h3>
                    <p>Watch on any device - Smart TV, Android, iOS, PC, Mac, Firestick and more.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="py-5 bg-light">
    <div class="container">
        <h2 class="text-center mb-5">Our Subscription Plans</h2>
        <div class="row g-4 justify-content-center">
            <?php
            $subscriptions = getAllSubscriptions();
            foreach ($subscriptions as $subscription): 
                $duration = $subscription['duration_days'] >= 30 ? 
                    floor($subscription['duration_days'] / 30) . ' Months' : 
                    $subscription['duration_days'] . ' Days';
            ?>
            <div class="col-md-4">
                <div class="pricing-card p-4 rounded shadow-sm text-center">
                    <h3 class="mb-3"><?= htmlspecialchars($subscription['name']) ?></h3>
                    <div class="price mb-3">
                        <span class="fs-1 fw-bold">$<?= number_format($subscription['price'], 2) ?></span>
                        <span class="text-muted">/ <?= $duration ?></span>
                    </div>
                    <p class="mb-4"><?= htmlspecialchars($subscription['description']) ?></p>
                    <a href="register.php" class="btn btn-outline-primary w-100">Get Started</a>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>