<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Digital Raptor</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    /* Critical footer fix */
    html, body, #__next {
      height: 100%;
    }
    body {
      display: flex;
      flex-direction: column;
      margin: 0;
    }
    main {
      flex: 1 0 auto;
    }
    footer {
      flex-shrink: 0;
    }
    
    /* Footer styling */
    .footer-border {
      height: 3px;
      background: linear-gradient(90deg, #3b82f6, #60a5fa, #3b82f6);
      background-size: 200% auto;
      animation: gradient 3s linear infinite;
    }
    @keyframes gradient {
      0% { background-position: 0% center; }
      100% { background-position: 200% center; }
    }
  </style>
</head>
<body class="flex flex-col min-h-screen bg-gray-50">



<!-- Fixed Footer -->
<footer class="bg-gradient-to-b from-gray-100 to-gray-200">
  <!-- Animated border -->
  <div class="footer-border"></div>
  
  <div class="container mx-auto px-4 py-6">
    <div class="flex flex-col md:flex-row justify-between items-center gap-4">
      <!-- Left section -->
      <div class="flex items-center mb-4 md:mb-0">
        <img src="../root/assets/img/digital_raptor.jpg" alt="Logo" class="h-8 mr-3 rounded">
        <div>
          <p class="text-sm font-medium text-gray-700">Digital Raptor</p>
          <p class="text-xs text-gray-500">Premium digital services</p>
        </div>
      </div>
      
      <!-- Payment methods -->
      <div class="mb-4 md:mb-0">
        <img src="../root/assets/img/Payment-Methods.webp" alt="Payments" class="h-6 mx-auto">
      </div>
      
      <!-- Right section -->
      <div class="flex flex-col items-center md:items-end">
        <div class="flex space-x-4 mb-2">
          <a href="/terms" class="text-sm text-gray-600 hover:text-blue-600">Terms</a>
          <a href="tel:+9779813848285" class="text-sm text-gray-600 hover:text-blue-600">Support</a>
        </div>
        <p class="text-xs text-gray-500 text-center md:text-right">
          &copy; <?= date('Y') ?> Digital Raptor. All rights reserved.
        </p>
      </div>
    </div>
  </div>
</footer>

</body>
</html>