<?php
// Prevent direct access

define('SITE_NAME', 'Digital Raptor IPTV');
define('SITE_URL', 'https://www.chandsher.com.np/IPTV/root/');
define('SITE_LOGO', 'assets/img/digital_raptor.jpg');
define('FOOTER_LOGO', 'assets/img/digital.jpg');
define('ADMIN_EMAIL', 'admin@digitalraptor.com'); // NEW: For contact/notifications

/**
 * =============================================
 * IPTV STREAMING CONFIGURATION
 * =============================================
 */
define('IPTV_PLAYLIST_URL', 'https://www.chandsher.com.np/IPTV/playlist.m3u');
define('MAX_STREAM_RETRIES', 3);
define('STREAM_TIMEOUT', 10);
define('MAX_CONCURRENT_STREAMS', 3); // NEW: Limit per user

/**
 * =============================================
 * PAYMENT GATEWAY CONFIGURATION
 * =============================================
 */
define('ESEWA_MERCHANT_ID', '9813848285');
define('KHALTI_MERCHANT_ID', '9813848285');
define('IMEPAY_MERCHANT_ID', '9813848285');

// NEW: Payment URLs (if available)
define('ESEWA_VERIFY_URL', 'https://esewa.com.np/epay/transverify');
define('KHALTI_VERIFY_URL', 'https://khalti.com/api/v2/payment/verify/');

/**
 * =============================================
 * SECURITY CONFIGURATION
 * =============================================
 */
define('SESSION_TIMEOUT', 1800); // 30 minutes
define('CSRF_TOKEN_LIFETIME', 3600); // 1 hour
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOGIN_ATTEMPT_WINDOW', 900); // 15 minutes
define('PASSWORD_RESET_EXPIRY', 3600); // NEW: 1 hour
define('API_KEY_EXPIRY', 86400); // NEW: 24 hours for API keys

/**
 * =============================================
 * ERROR HANDLING CONFIGURATION
 * =============================================
 */
error_reporting(E_ALL);
ini_set('display_errors', 1); // Should be 0 in production
ini_set('log_errors', 1);
define('ERROR_LOG_PATH', __DIR__ . '/../logs/error.log'); // NEW
ini_set('error_log', ERROR_LOG_PATH);

/**
 * =============================================
 * SESSION CONFIGURATION
 * =============================================
 */
session_set_cookie_params([
    'lifetime' => SESSION_TIMEOUT,
    'path' => '/',
    'domain' => $_SERVER['HTTP_HOST'],
    'secure' => isset($_SERVER['HTTPS']),
    'httponly' => true,
    'samesite' => 'Lax'
]);

// Start session only if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Initialize CSRF token if not exists
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    $_SESSION['csrf_token_time'] = time();
}

// Session security regeneration
if (!isset($_SESSION['last_regeneration']) || 
    (time() - $_SESSION['last_regeneration'] > 300)) {
    session_regenerate_id(true);
    $_SESSION['last_regeneration'] = time();
    
    // Store additional security info
    $_SESSION['ip_address'] = $_SERVER['REMOTE_ADDR'];
    $_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
}

/**
 * =============================================
 * FILE INCLUDES
 * =============================================
 */
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/functions.php';

// NEW: Load environment variables if using .env
if (file_exists(__DIR__ . '/.env')) {
    $env = parse_ini_file(__DIR__ . '/.env');
    foreach ($env as $key => $value) {
        putenv("$key=$value");
    }
}