<?php
// api/wallet.php

require_once '../includes/config.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $balance = getWalletBalance($_SESSION['user_id']);
    
    // Get transactions
    $stmt = $pdo->prepare("
        SELECT wt.* 
        FROM wallet_transactions wt
        JOIN wallet w ON wt.wallet_id = w.id
        WHERE w.user_id = ?
        ORDER BY wt.created_at DESC
        LIMIT 10
    ");
    $stmt->execute([$_SESSION['user_id']]);
    $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'balance' => $balance,
        'transactions' => $transactions
    ]);
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (isset($data['amount']) && isset($data['payment_method'])) {
        $amount = floatval($data['amount']);
        $payment_method = sanitizeInput($data['payment_method']);
        
        if ($amount <= 0) {
            http_response_code(400);
            echo json_encode(['error' => 'Invalid amount']);
            exit();
        }
        
        if (!in_array($payment_method, ['esewa', 'khalti', 'imepay', 'fonepay'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Invalid payment method']);
            exit();
        }
        
        // Create transaction
        $transaction_id = addWalletTransaction($_SESSION['user_id'], $amount, 'deposit', "Deposit via " . ucfirst($payment_method));
        
        // For demo, we'll immediately complete it
        completeWalletTransaction($transaction_id);
        
        echo json_encode([
            'success' => true,
            'message' => 'Deposit initiated',
            'transaction_id' => $transaction_id
        ]);
    } else {
        http_response_code(400);
        echo json_encode(['error' => 'Amount and payment method are required']);
    }
} else {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'message' => 'Method not allowed'
    ]);
}
?>