<?php
require_once __DIR__ . '/config.php';

function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function getUserById($id) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$id]);
    return $stmt->fetch();
}

function getWalletBalance($user_id) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT balance FROM wallet WHERE user_id = ?");
    $stmt->execute([$user_id]);
    return $stmt->fetchColumn() ?? 0.00;
}

function addWalletTransaction($user_id, $amount, $type, $reference, $status = 'pending') {
    global $pdo;
    
    try {
        $stmt = $pdo->prepare("SELECT id FROM wallet WHERE user_id = ?");
        $stmt->execute([$user_id]);
        $wallet_id = $stmt->fetchColumn();
        
        if (!$wallet_id) return false;
        
        $stmt = $pdo->prepare("
            INSERT INTO wallet_transactions 
            (wallet_id, amount, transaction_type, reference, status) 
            VALUES (?, ?, ?, ?, ?)
        ");
        $stmt->execute([$wallet_id, $amount, $type, $reference, $status]);
        
        return $pdo->lastInsertId();
    } catch (PDOException $e) {
        error_log("Transaction error: " . $e->getMessage());
        return false;
    }
}