<?php
function isAdminLoggedIn() {
    if (session_status() === PHP_SESSION_NONE) session_start();
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

function adminLogin($username, $password) {
    global $pdo;
    
    try {
        $stmt = $pdo->prepare("SELECT * FROM admin_users WHERE username = ? AND is_active = TRUE");
        $stmt->execute([$username]);
        $admin = $stmt->fetch();
        
        if ($admin && password_verify($password, $admin['password_hash'])) {
            session_regenerate_id(true);
            $_SESSION['admin_id'] = $admin['id'];
            $_SESSION['admin_username'] = $admin['username'];
            $_SESSION['admin_logged_in'] = true;
            
            $pdo->prepare("UPDATE admin_users SET last_login = NOW() WHERE id = ?")
               ->execute([$admin['id']]);
            return true;
        }
    } catch (PDOException $e) {
        error_log("Admin login error: " . $e->getMessage());
    }
    return false;
}

function adminLogout() {
    $_SESSION = [];
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }
    session_destroy();
}

function getPendingDeposits() {
    global $pdo;
    $stmt = $pdo->query("
        SELECT wt.*, u.username 
        FROM wallet_transactions wt
        JOIN wallet w ON wt.wallet_id = w.id
        JOIN users u ON w.user_id = u.id
        WHERE wt.status = 'pending' AND wt.transaction_type = 'deposit'
        ORDER BY wt.created_at DESC
    ");
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

function processWalletTransaction($transaction_id, $action) {
    global $pdo;
    
    try {
        $pdo->beginTransaction();
        $status = ($action === 'approve') ? 'completed' : 'rejected';
        $stmt = $pdo->prepare("UPDATE wallet_transactions SET status = ? WHERE id = ?");
        $stmt->execute([$status, $transaction_id]);
        
        if ($action === 'approve') {
            $stmt = $pdo->prepare("
                UPDATE wallet w
                JOIN wallet_transactions wt ON w.id = wt.wallet_id
                SET w.balance = w.balance + wt.amount
                WHERE wt.id = ? AND wt.status = 'completed'
            ");
            $stmt->execute([$transaction_id]);
        }
        
        $pdo->commit();
        return true;
    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Transaction error: " . $e->getMessage());
        return false;
    }
}