<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/admin_functions.php';

if (!isAdminLoggedIn()) redirect('login.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $transaction_id = intval($_POST['transaction_id']);
    $action = sanitizeInput($_POST['action']);
    
    if (in_array($action, ['approve', 'reject'])) {
        if (processWalletTransaction($transaction_id, $action)) {
            $_SESSION['admin_message'] = "Transaction $action" . "d successfully";
        } else {
            $_SESSION['admin_error'] = "Failed to process transaction";
        }
        redirect('wallet_approval.php');
    }
}

$pending_deposits = getPendingDeposits();
require_once 'includes/admin_header.php';
?>
<div class="admin-container">
    <?php include 'includes/admin_sidebar.php'; ?>
    <div class="admin-content">
        <h1>Wallet Approvals</h1>
        <?php if (isset($_SESSION['admin_message'])): ?>
            <div class="alert success"><?= $_SESSION['admin_message'] ?></div>
            <?php unset($_SESSION['admin_message']); ?>
        <?php endif; ?>
        <?php if (isset($_SESSION['admin_error'])): ?>
            <div class="alert error"><?= $_SESSION['admin_error'] ?></div>
            <?php unset($_SESSION['admin_error']); ?>
        <?php endif; ?>
        <?php if (empty($pending_deposits)): ?>
            <p>No pending deposits</p>
        <?php else: ?>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>ID</th><th>User</th><th>Amount</th><th>Date</th><th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($pending_deposits as $deposit): ?>
                    <tr>
                        <td><?= $deposit['id'] ?></td>
                        <td><?= htmlspecialchars($deposit['username']) ?></td>
                        <td>$<?= number_format($deposit['amount'], 2) ?></td>
                        <td><?= date('M d, Y', strtotime($deposit['created_at'])) ?></td>
                        <td>
                            <form method="POST" style="display:inline">
                                <input type="hidden" name="transaction_id" value="<?= $deposit['id'] ?>">
                                <button type="submit" name="action" value="approve" class="btn btn-approve">Approve</button>
                                <button type="submit" name="action" value="reject" class="btn btn-reject">Reject</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>
<?php require_once 'includes/admin_footer.php'; ?>