<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/admin_functions.php';

if (!isAdminLoggedIn()) redirect('login.php');

// Get stats
$pending_deposits = count(getPendingDeposits());
$total_users = 0;

try {
    $total_users = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
} catch (PDOException $e) {
    error_log("Error counting users: " . $e->getMessage());
}

require_once 'includes/admin_header.php';
?>
<div class="admin-container">
    <?php include 'includes/admin_sidebar.php'; ?>
    <div class="admin-content">
        <h1>Dashboard Overview</h1>
        <div class="stats-grid">
            <div class="stat-card">
                <h3>Total Users</h3>
                <p><?= $total_users ?></p>
            </div>
            <div class="stat-card">
                <h3>Pending Deposits</h3>
                <p><?= $pending_deposits ?></p>
            </div>
        </div>
    </div>
</div>
<?php require_once 'includes/admin_footer.php'; ?>